#include <8052.h>
#include "stdio.h"

unsigned char CHI;

//init_com() iinitializes the serial communication
void init_com()
{
 TR1=0;		
 TH1=0xfd;  // for baud rate = 9600
 PCON=0x80; // to double the baud rate to 19200
 TL1=0;
 TMOD=0x20; // timer 1 mode 2
 SCON=0xde;	// 9 bit for 2 stop bits
 TR1=1;
}

//co(CH) transmits one byte
void co(unsigned char CH)
{
 while(!TI);
 TI = 0;
 SBUF = CH;
}

//wci() waits for a character and returns it
unsigned char wci()
{
 while(!RI);
 RI = 0;
 return SBUF;
}

//ci() returns received serial character
//or 0 if there is no character
//without waiting
unsigned char ci()
{
 if (!RI) return 0;
 else
  {
   RI = 0;
   return SBUF;
  }
}

void delay()
{
unsigned int i;
 for (i =1; i<32000;i++);
}


// -----------------
// putchar enables put printf formatted string to 
// device you decided.

// if decided writing to COM then use rutine co 
// in this case you are able see the printing on terminal screen in SES51c
// or on HiperTerminal of windows with baud rate 19200 

// if you have a LCD then in this rutine you use print of 1 character to lcd

// If youre short on memory you might want to use printf_small() instead of printf(). 
// For the mcs51 there is an assembly version printf_fast() which should fit the requirements 
// of many embedded systems (by unsetting #defines it can be customized 
// to not support long variables and field widths.
 

void putchar (char c)
{
	co(c);	
}
//sample main program that waits for character 
//and sends echo to terminal
void main(void)
{ unsigned char i;
 init_com();
   printf_fast  ( "\n\r     Press Any Key  \n\r "	);
 i=1;
 while (1)
 {

// using printf
   CHI = wci(); 
  // co(0xd);  // it's cariage return
   printf_fast ( "\n\r Ascii - %c   decimal -  %2d"    ,(char) CHI, CHI	);
   i=0;
 }
}








